(async function () {
    const bodyContainer = document.getElementById('bodyContainer');
    const locatorForm = document.getElementById('locatorForm');
    const errorMessageBlock = document.getElementById('errorMessage');
    const errorMessageBlockJQ = $('#errorMessage');
    const pageTypeAliasContainer = document.getElementById('pageTypeAliasContainer');
    const keyText = document.getElementById('key');
    const infoKey = document.getElementById('infoKey');
    const keyContainer = document.getElementById('keyContainer');
    const pageNameText = document.getElementById('pageName');
    const infoPageName = document.getElementById('infoPageName');
    const typeText = document.getElementById('type');
    const infoType = document.getElementById('infoType');
    const aliasText = document.getElementById('alias');
    const infoAlias = document.getElementById('infoAlias');
    const keyPartsContainer = document.getElementById('keyPartsContainer');
    const xpathText = document.getElementById('xpath');
    const infoXPath = document.getElementById('infoXPath');
    const cssText = document.getElementById('css');
    const infoCss = document.getElementById('infoCss');
    const frameText = document.getElementById('frame');
    const infoFrame = document.getElementById('infoFrame');
    const popupText = document.getElementById('popup');
    const infoPopup = document.getElementById('infoPopup');

    const copyXPathBtn = document.getElementById('copyXPath');
    const copyCssBtn = document.getElementById('copyCss');

    const pushToServerBtn = document.getElementById('pushToServerBtn');
    const testBtn = document.getElementById('testBtn');
    const continueBtn = document.getElementById('continueBtn');
    const backBtn = document.getElementById('backBtn');
    const cancelBtn = document.getElementById('cancelBtn');
    let locator = {};
    let hint;
    let saveFeatureEnabled = false;
    let validator;
    let options;
    let isFrameset = false;
    let isDisabledHint = false;
    let tooltipTriggerList;
    let tooltipList;
    let popoverTriggerList;
    let popoverList;

    const bodyClickHandler = () => {
        $('[data-bs-toggle="popover"]').popover('hide');
    };

    const formSubmitHandler = event => {
        event.preventDefault();
    };

    const isSpecialKey = keyCode => {
        switch (keyCode) {
            case 9:
            case 13:
            case 16:
            case 17:
            case 18:
            case 19:
            case 20:
            case 27:
            case 33:
            case 34:
            case 35:
            case 36:
            case 37:
            case 38:
            case 39:
            case 40:
            case 112:
            case 113:
            case 114:
            case 115:
            case 116:
            case 117:
            case 118:
            case 119:
            case 120:
            case 121:
            case 122:
            case 123:
            case 144:
            case 145:
                return true;
            default:
                return false;
        }
    };

    const infoClickHandler = event => {
        let id = event.currentTarget.id;

        event.stopImmediatePropagation();
        event.stopPropagation();

        if (id && id.length) {
            $('#'.concat(id)).tooltip('hide');

            switch (id) {
                case 'infoKey':
                case 'infoPageName':
                case 'infoType':
                case 'infoAlias':
                case 'infoXPath':
                case 'infoCss':
                case 'infoFrame':
                case 'infoPopup':
                    bodyClickHandler();
                    $('#' + id + 'Label').popover('show');
                    break;
                default:
                    break;
            }
        }
    };

    const fieldInputHandler = event => {
        if (isSpecialKey(event.which)) {
            return;
        }

        locator.pageName = pageNameText.value;
        locator.type = typeText.value;
        locator.alias = aliasText.value;
        locator.xpath = xpathText.value;
        locator.cssSelector = cssText.value;
        locator.frame = frameText.value;
        locator.popup = popupText.value;
        setKeyTextValue();
        pushToServerBtn.disabled = isLocatorFieldsNotFilled() || isCssAndXpathNotFilled();
        testBtn.disabled = isCssAndXpathNotFilled();
    };

    const pageNameKeyDownHandler = event => {
        if (isSpecialKey(event.which)) {
            return;
        }

        if (event.keyCode === 13) {
            event.preventDefault();
            typeText.focus();
        }
    };

    const typeKeyDownHandler = event => {
        if (isSpecialKey(event.which)) {
            return;
        }

        locator.type = typeText.value;
        setKeyTextValue();
        pushToServerBtn.disabled = isLocatorFieldsNotFilled() || isCssAndXpathNotFilled();

        if (event.keyCode === 13) {
            event.preventDefault();
            aliasText.focus();
        }
    };

    const aliasKeyDownHandler = event => {
        if (isSpecialKey(event.which)) {
            return;
        }

        locator.alias = aliasText.value;
        setKeyTextValue();
        pushToServerBtn.disabled = isLocatorFieldsNotFilled() || isCssAndXpathNotFilled();

        if (event.keyCode === 13) {
            event.preventDefault();
            xpathText.focus();
        }
    };

    const xpathKeyDownHandler = event => {
        if (isSpecialKey(event.which)) {
            return;
        }

        if (event.keyCode === 13) {
            event.preventDefault();
            cssText.focus();
        }
    };

    const xpathKeyUpHandler = event => {
        if (isSpecialKey(event.which)) {
            return;
        }

        locator.xpath = xpathText.value;
        pushToServerBtn.disabled = isLocatorFieldsNotFilled() || isCssAndXpathNotFilled();
        testBtn.disabled = isCssAndXpathNotFilled();
        copyXPathBtn.disabled = isEmptyField(xpathText.value);
    };

    const cssKeyDownHandler = event => {
        if (event.keyCode === 13) {
            event.preventDefault();
            frameText.focus();
        }
    };

    const cssKeyUpHandler = () => {
        if (isSpecialKey(event.which)) {
            return;
        }

        locator.cssSelector = cssText.value;
        pushToServerBtn.disabled = isLocatorFieldsNotFilled() || isCssAndXpathNotFilled();
        testBtn.disabled = isCssAndXpathNotFilled();
        copyCssBtn.disabled = isEmptyField(cssText.value);
    };

    const frameKeyDownHandler = event => {
        if (isSpecialKey(event.which)) {
            return;
        }

        locator.frame = frameText.value;

        if (event.keyCode === 13) {
            event.preventDefault();
            popupText.focus();
        }
    };

    const popupKeyDownHandler = event => {
        if (isSpecialKey(event.which)) {
            return;
        }

        locator.popup = popupText.value;

        if (event.keyCode === 13) {
            event.preventDefault();
            if (saveFeatureEnabled) {
                if (!(isLocatorFieldsNotFilled() || isCssAndXpathNotFilled())) {
                    pushToServerBtn.click();
                }
                pageNameText.focus();
            } else {
                if (!isCssAndXpathNotFilled()) {
                    testBtn.click();
                }
                xpathText.focus();
            }
        }
    };

    const copyXPathClickHandler = () => {
        copyToClipboard(xpathText);
    };

    const copyCssClickHandler = () => {
        copyToClipboard(cssText);
    };

    const copyToClipboard = element => {
        element.select();
        element.setSelectionRange(0, 99999);
        document.execCommand('copy');
        window.getSelection().removeAllRanges();
    };

    const pushToServerClickHandler = async () => {
        if ($('#locatorForm').valid()) {
            const data = await chrome.storage.local.get('settings');

            if (!data.settings) {
                chrome.runtime.sendMessage({
                    action: CONSTANTS.ACTIONS.SEND_NOTIFICATION_MESSAGE,
                    message: CONSTANTS.NOTIFICATION_MESSAGES.SETTINGS_NOT_FOUND,
                    type: CONSTANTS.NOTIFICATION_TYPES.ERROR
                });
                return;
            }
            let savingLocator = Object.assign({}, locator);
            let selectors = getSelectorsToSend(data.settings.saveCssSelector);

            savingLocator.xpath = selectors.xpath;
            savingLocator.cssSelector = selectors.css;

            await saveLocator(savingLocator, data.settings);
        }
    };

    const testClickHandler = () => {
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.LOCATOR_DIALOG_RESULT,
            result: {
                type: CONSTANTS.ACTIONS.TEST,
                xpath: locator.xpath,
                cssSelector: locator.cssSelector,
                isFrameset
            }
        });
    };

    const continueClickHandler = () => {
        closeDialog(true);
    };

    const backClickHandler = () => {
        resetFormValidation();
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.LOCATOR_DIALOG_RESULT,
            result: {
                type: CONSTANTS.ACTIONS.BACK_TO_HINT,
                hint,
                isFrameset,
                isDisabledHint
            }
        });
    };

    const cancelClickHandler = () => {
        closeDialog(false);
    };

    const getSelectorsToSend = saveCssSelector => {
        let {xpath, cssSelector} = locator;

        if (((xpath !== null && xpath.length > 0) &&
                (cssSelector !== null && cssSelector.length > 0 && saveCssSelector)) ||
            ((xpath === null || xpath.length === 0) &&
                (cssSelector !== null && cssSelector.length > 0))) {
            return {
                xpath: null,
                css: cssSelector
            };
        }

        if (((xpath !== null && xpath.length > 0) &&
                (cssSelector !== null && cssSelector.length > 0 && !saveCssSelector)) ||
            ((cssSelector === null || cssSelector.length === 0) &&
                (xpath !== null && xpath.length > 0))) {
            return {
                xpath: xpath,
                css: null
            };
        }

        return {
            xpath: xpath,
            css: cssSelector
        };
    };

    const saveLocator = async (savingLocator, settings) => {
        let headers = settings.isBasicAuth ?
            {
                'Authorization': 'Basic ' + settings.auth
            } :
            {
                'X-API-KEY': settings.auth
            };

        await chrome.storage.local.set({locator: savingLocator});

        $("#overlay").fadeIn(300);

        await ApiService.sendPostRequest(
            settings.host.concat(CONSTANTS.REQUEST_PATHS.LOCATORS),
            headers,
            JSON.stringify(savingLocator),
            (data, status) => {
                ApiService.onSuccessHandler(data, status, CONSTANTS.NOTIFICATION_MESSAGES.LOCATOR_SAVED, settings.isBasicAuth, null,
                    () => {
                        closeDialog(true);
                    });
            },
            errorMessage => {
                ApiService.onErrorHandler(errorMessage,
                    () => {
                        pageNameText.focus();
                    });
            }
        );
    };

    const closeDialog = skip => {
        resetFormValidation();
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.LOCATOR_DIALOG_RESULT,
            result: {
                type: CONSTANTS.ACTIONS.SKIP,
                skip,
                isFrameset
            }
        });
    };

    const resetFormValidation = () => {
        validator.errorList = [];
        validator.defaultShowErrors([]);
        validator.resetForm();
        validator.reset();
    };

    const setKeyTextValue = () => {
        keyText.value = (pageNameText.value ? pageNameText.value + '.' : '') +
            (typeText.value ? typeText.value + '.' : '') +
            (aliasText.value ? aliasText.value : '');
    };

    const setTextValue = (textElement, value) => {
        textElement.value = value ? value : '';
    };

    const isCssAndXpathNotFilled = () => {
        return isDisabledHint ?
            isEmptyField(cssText.value) :
            isEmptyField(xpathText.value) && isEmptyField(cssText.value);
    };

    const isLocatorFieldsNotFilled = () => {
        return isEmptyField(pageNameText.value) || isEmptyField(typeText.value) || isEmptyField(aliasText.value);
    };

    const isEmptyField = value => {
        return value === null || typeof value === 'undefined' || value.length === 0;
    };

    const setValidationOptions = () => {
        $.validator.addMethod('pattern', function (value, element, params) {
            const expression = new RegExp(params);
            return this.optional(element) || expression.test(value);
        });

        options = {
            rules: {
                pageName: getRulesForKey(),
                type: getRulesForKey(),
                alias: getRulesForKey(),
            },
            messages: {
                pageName: {
                    required: 'Web Page is required',
                    pattern: 'Web Page may not contain any white spaces, dashes, dots etc. Use \'_\' as separator instead'
                },
                type: {
                    required: 'Type is required',
                    pattern: 'Type may not contain any white spaces, dashes, dots etc. Use \'_\' as separator instead'
                },
                alias: {
                    required: 'Alias is required',
                    pattern: 'Alias may not contain any white spaces, dashes, dots etc. Use \'_\' as separator instead'
                },
            },
            errorClass: 'is-invalid',
            errorPlacement: function(error, element) {
                const tooltip = element.parent().find('.invalid-tooltip');
                if (tooltip.length) {
                    tooltip.text(error.text());
                } else {
                    element.after(`<div class="invalid-tooltip">${error.text()}</div>`);
                }
            },
        };

        validator = $('#locatorForm').validate(options);
    };

    const validateForm = () => {
        validator = $('#locatorForm').validate(options);
    };

    const getRulesForKey = () => {
        return {
            required: {
                depends: () => {
                    return saveFeatureEnabled;
                }
            },
            pattern: {
                depends: () => {
                    return saveFeatureEnabled;
                },
                param: /^[_a-zA-Z0-9]+$/,
            }
        }
    };

    const updateTooltips = () => {
        tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
        tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    };

    const updatePopovers = () => {
        popoverTriggerList = document.querySelectorAll('[data-bs-toggle="popover"]');
        popoverList = [...popoverTriggerList].map(popoverTriggerEl => new bootstrap.Popover(popoverTriggerEl));
    };

    updateTooltips();
    updatePopovers();
    bodyClickHandler();
    setValidationOptions();
    validateForm();

    const data = await chrome.storage.local.get(['locator', 'hint', 'saveFeatureEnabled', 'isFrameset']);

    if (data.locator) {
        locator = data.locator;
    }
    resetFormValidation();
    isDisabledHint = data.isDisabledHint;
    copyCssBtn.disabled = !locator.cssSelector;
    hint = data.hint;
    locator.alias = hint.text[0] !== null ?
        hint.text.length === 2 ?
            hint.text[0]
                .replace(/[\. ]/, '_')
                .replace(/[^\w]/gi, '')
                .toLowerCase()
            + '_' +
            hint.text[1]
                .replace(/[\. ]/, '_')
                .replace(/[^\w]/gi, '')
                .toLowerCase():
            hint.text[0]
                .replace(/[\. ]/, '_')
                .replace(/[^\w]/gi, '')
                .toLowerCase() :
        '';
    saveFeatureEnabled = data.saveFeatureEnabled;
    isFrameset = data.isFrameset;

    errorMessageBlock.style.display = isDisabledHint ? '' : 'none';
    errorMessageBlock.innerText = isDisabledHint ? CONSTANTS.ERROR_MESSAGES.CUSTOM_CSS_SELECTOR_WILL_BE_GENERATED : '';
    if (!saveFeatureEnabled) {
        errorMessageBlockJQ.addClass('alert-locator');
    } else {
        errorMessageBlockJQ.removeClass('alert-locator');
    }
    xpathText.disabled = isDisabledHint;


    setTextValue(pageNameText, locator.pageName);
    setTextValue(typeText, locator.type);
    setTextValue(aliasText, locator.alias);
    setTextValue(xpathText, locator.xpath);
    setTextValue(cssText, locator.cssSelector);
    setTextValue(frameText, locator.frame);
    setTextValue(popupText, locator.popup);
    setKeyTextValue();

    keyText.style.display = saveFeatureEnabled ? '' : 'none';
    keyContainer.style.display = saveFeatureEnabled ? '' : 'none';
    pageNameText.style.display = saveFeatureEnabled ? '' : 'none';
    typeText.style.display = saveFeatureEnabled ? '' : 'none';
    aliasText.style.display = saveFeatureEnabled ? '' : 'none';
    keyPartsContainer.style.display = saveFeatureEnabled ? '' : 'none';
    pushToServerBtn.style.display = saveFeatureEnabled ? '' : 'none';
    keyContainer.style.marginBottom = saveFeatureEnabled ? '1rem;' : '0';
    keyPartsContainer.style.marginBottom = saveFeatureEnabled ? '1rem;' : '0';

    keyText.disabled = true;
    pushToServerBtn.disabled = isLocatorFieldsNotFilled() || isCssAndXpathNotFilled();
    testBtn.disabled = isCssAndXpathNotFilled();

    copyXPathBtn.disabled = isDisabledHint;

    validateForm();

    if (saveFeatureEnabled) {
        pageNameText.focus();
    } else {
        xpathText.focus();
    }

    bodyContainer.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, bodyClickHandler);
    locatorForm.addEventListener(CONSTANTS.EVENTS.DOM.SUBMIT, formSubmitHandler);

    infoKey.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);

    pageNameText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, pageNameKeyDownHandler);
    pageNameText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    pageNameText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoPageName.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);

    typeText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, typeKeyDownHandler);
    typeText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    typeText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoType.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);

    aliasText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, aliasKeyDownHandler);
    aliasText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    aliasText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoAlias.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);

    xpathText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, xpathKeyDownHandler);
    xpathText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_UP, xpathKeyUpHandler);
    xpathText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    xpathText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoXPath.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);

    cssText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, cssKeyDownHandler);
    cssText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_UP, cssKeyUpHandler);
    cssText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    cssText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoCss.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);

    frameText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, frameKeyDownHandler);
    frameText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    frameText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoFrame.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);

    popupText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, popupKeyDownHandler);
    popupText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    popupText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoPopup.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);

    copyXPathBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, copyXPathClickHandler);
    copyCssBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, copyCssClickHandler);

    pushToServerBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, pushToServerClickHandler);
    testBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, testClickHandler);
    continueBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, continueClickHandler);
    backBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, backClickHandler);
    cancelBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, cancelClickHandler);

    chrome.storage.onChanged.addListener((changes, areaName) => {
        if (areaName === 'local' && changes.saveFeatureEnabled) {
            pushToServerBtn.style.display = changes.saveFeatureEnabled?.newValue ? '' : 'none';
        }
    });

    $(function () {
        $('[data-toggle="tooltip"]').tooltip();
        $('[data-toggle="popover"]').popover();
    })

    ApiService();
})();
