const handleMessage = (() => {
    const bodyContainer = document.getElementById('bodyContainer');
    const errorMessageBlock = document.getElementById('errorMessage');
    const hintText = document.getElementById('hintText');
    const infoHint = document.getElementById('infoHint');
    const advancedAhref = document.getElementById('advanced');
    const advancedAhrefJQ = $('#advanced');
    const advancedUpSpan = document.getElementById('advancedUp');
    const advancedDownSpan = document.getElementById('advancedDown');
    const advancedContainer = document.getElementById('advancedContainer');
    const maxDistance = $('#maxDistance');
    const infoDistance = document.getElementById('infoDistance');
    const matchCaseChkBox = document.getElementById('matchCase');
    const fullMatchChkBox = document.getElementById('fullMatch');
    const useIdAttributeChkBox = document.getElementById('useIdAttribute');
    const generateBtn = document.getElementById('generateBtn');
    const skipBtn = document.getElementById('skipBtn');
    const cancelBtn = document.getElementById('cancelBtn');
    const reloadTemplatesBtn = document.getElementById('reloadTemplatesBtn');
    let hint = {};
    let advanced = false;
    let isFrameset = false;
    let isDisabledHint = false;
    let isDisabledGenerating = false;
    let saveFeatureEnabled = false;
    let tooltipTriggerList;
    let tooltipList;
    let popoverTriggerList;
    let popoverList;

    const bodyClickHandler = () => {
        $('[data-bs-toggle="popover"]').popover('hide');
    };

    const hintTextKeyUpHandler = event => {
        generateBtn.disabled = isDisabledHint ? isDisabledGenerating : false;
        matchCaseChkBox.disabled = !hintText.value;

        if (event.keyCode === 13) {
            event.preventDefault();
            generateBtn.click();
        }
    };

    const fieldInputHandler = () => {
        generateBtn.disabled = isDisabledHint ? isDisabledGenerating : false;
        matchCaseChkBox.disabled = !hintText.value;
    };

    const infoClickHandler = event => {
        let id = event.currentTarget.id;

        event.stopImmediatePropagation();
        event.stopPropagation();

        if (id && id.length) {
            $('#'.concat(id)).tooltip('hide');

            switch (id) {
                case 'infoHint':
                case 'infoDistance':
                    bodyClickHandler();
                    $('#' + id + 'Label').popover('show');
                    break;
                default:
                    break;
            }
        }
    };

    const openAdvanceOptionsHandler = () => {
        if (isDisabledHint) {
            return;
        }

        advanced = !advanced;
        updateAdvancedOptions();
        updateHeight();
    };

    const generateClickHandler = async () => {
        await sendHint();
    };

    const skipClickHandler = () => {
        closeDialog(true);
    };

    const cancelClickHandler = () => {
        closeDialog(false);
    };

    const reloadTemplatesClickHandler = async () => {
        const storageData = await chrome.storage.local.get('settings');

        if (!storageData.settings) {
            chrome.runtime.sendMessage({
                action: CONSTANTS.ACTIONS.SEND_NOTIFICATION_MESSAGE,
                message: CONSTANTS.NOTIFICATION_MESSAGES.SETTINGS_NOT_FOUND,
                type: CONSTANTS.NOTIFICATION_TYPES.ERROR
            });
            return;
        }

        let headers = storageData.settings.isBasicAuth ?
            {
                'Authorization': 'Basic ' + storageData.settings.auth
            } :
            {
                'X-API-KEY': storageData.settings.auth
            };

        $('#overlay').fadeIn(300);

        await ApiService.sendGetRequest(
            storageData.settings.host.concat(CONSTANTS.REQUEST_PATHS.XPATH_TEMPLATES),
            headers,
            (data, status) => {
                ApiService.onSuccessHandler(data, status, CONSTANTS.NOTIFICATION_MESSAGES.XPATH_TEMPLATES_RECEIVED,
                    storageData.settings.isBasicAuth, null,
                    async () => {
                        reloadTemplatesBtn.blur();
                        if (status === 200) {
                            await chrome.storage.local.set({templates: data});
                        }
                    });
            },
            errorMessage => {
                ApiService.onErrorHandler(errorMessage,
                    () => {
                        reloadTemplatesBtn.blur();
                    });
            }
        );
    };

    const sendHint = async () => {
        hint = {
            text: hintText.value && hintText.value.length !== 0 ? hintText.value : null,
            maxDistance: Number.parseInt(maxDistance.val(), 10),
            matchCase: matchCaseChkBox.checked,
            fullMatch: fullMatchChkBox.checked,
            useIdAttribute: useIdAttributeChkBox.checked
        };
        await chrome.storage.local.set({hint});
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.HINT_DIALOG_RESULT,
            hint,
            isFrameset,
            isDisabledHint
        });
    };

    const closeDialog = skip => {
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.HINT_DIALOG_RESULT,
            skip,
            isFrameset,
            isDisabledHint
        });
    };

    const updateAdvancedOptions = () => {
        advancedUpSpan.style.display = advanced ? '' : 'none';
        advancedDownSpan.style.display = !advanced ? '' : 'none';
        advancedContainer.style.display = advanced ? '' : 'none';
    };

    const updateTooltips = () => {
        tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
        tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    };

    const updatePopovers = () => {
        popoverTriggerList = document.querySelectorAll('[data-bs-toggle="popover"]');
        popoverList = [...popoverTriggerList].map(popoverTriggerEl => new bootstrap.Popover(popoverTriggerEl));
    };

    const updateHeight = () => {
        const overflowBefore = document.body.style.overflow;
        document.body.style.overflow = CONSTANTS.VISIBILITY.HIDDEN;
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.SYNC_DIALOG_SIZE,
            dialogType: CONSTANTS.DIALOG_FRAME_OPTIONS.HINT.TYPE,
            dialogWidth: document.body.scrollWidth,
            dialogHeight: document.body.scrollHeight
        });
        document.body.style.overflow = overflowBefore;
    };

    updateTooltips();
    updatePopovers();

    return event => {
        if (!event.data.sender || event.data.sender !== CONSTANTS.MESSAGE_SENDERS.S7_OPEN_HINT_WINDOW) {
            return;
        }
        hint = event.data.hint ?
            event.data.hint :
            {
                text: '',
                maxDistance: 25,
                matchCase: false,
                fullMatch: false,
                useIdAttribute: false
            };
        bodyClickHandler();
        saveFeatureEnabled = event.data.saveFeatureEnabled;
        isFrameset = event.data.isFrameset;
        advanced = false;
        isDisabledHint = event.data.isDisabledHint;
        isDisabledGenerating = event.data.isDisabledGenerating;

        errorMessageBlock.style.display = isDisabledHint ? '' : 'none';
        errorMessageBlock.innerText = isDisabledHint ?
            isDisabledGenerating ?
                CONSTANTS.ERROR_MESSAGES.XPATH_AND_CSS_CAN_NOT_BE_GENERATED :
                CONSTANTS.ERROR_MESSAGES.CUSTOM_CSS_SELECTOR_WILL_BE_GENERATED
            :
            '';
        hintText.disabled = isDisabledHint;
        hintText.value = hint.text;
        updatePopovers();
        updateAdvancedOptions();
        maxDistance.val(hint.maxDistance).change();
        matchCaseChkBox.checked = hint.matchCase;
        fullMatchChkBox.checked = hint.fullMatch;
        useIdAttributeChkBox.checked = hint.useIdAttribute;
        generateBtn.disabled = isDisabledHint ? isDisabledGenerating : false;
        reloadTemplatesBtn.style.display = saveFeatureEnabled && !isDisabledHint ? '' : 'none';

        if (isDisabledHint) {
            advancedAhrefJQ.addClass('disabled-href');
        } else {
            advancedAhrefJQ.removeClass('disabled-href');
        }

        if (isDisabledHint) {
            if (isDisabledGenerating) {
                cancelBtn.focus();
            } else {
                generateBtn.focus();
            }
        } else {
            hintText.focus();
        }

        bodyContainer.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, bodyClickHandler);
        hintText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_UP, hintTextKeyUpHandler);
        hintText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
        hintText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
        infoHint.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);
        advancedAhref.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, openAdvanceOptionsHandler);
        infoDistance.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);
        generateBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, generateClickHandler);
        skipBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, skipClickHandler);
        cancelBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, cancelClickHandler);
        reloadTemplatesBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, reloadTemplatesClickHandler);

        updateHeight();

        chrome.storage.onChanged.addListener((changes, areaName) => {
            if (areaName === 'local' && changes.saveFeatureEnabled) {
                reloadTemplatesBtn.style.display = changes.saveFeatureEnabled?.newValue && !isDisabledHint ? '' : 'none';
            }
        });
    }
})();

$(function () {
    $('[data-bs-toggle="tooltip"]').tooltip();
    $('[data-bs-toggle="popover"]').popover();
})

ApiService();

window.addEventListener(CONSTANTS.EVENTS.WINDOW.MESSAGE, handleMessage);
