ApiService();

document.addEventListener(CONSTANTS.EVENTS.WINDOW.DOM_CONTENT_LOADED, async () => {
    const bodyContainer = document.getElementById('bodyContainer');
    const settingsForm = document.getElementById('settingsForm');
    const usernameContainer = document.getElementById('usernameContainer');
    const passwordContainer = document.getElementById('passwordContainer');
    const apikeyLabelContainer = document.getElementById('apikeyLabelContainer');
    const apikeyContainer = document.getElementById('apikeyContainer');
    const hostText = document.getElementById('host');
    const infoHost = document.getElementById('infoHost');
    const infoSwitcher = document.getElementById('infoSwitcher');
    const basicAuthRadio = document.getElementById('basicAuthRadio');
    const apiKeyRadio = document.getElementById('apiKeyRadio');
    const pasteApiKeyBtn = document.getElementById('pasteApiKey');
    const usernameText = document.getElementById('username');
    const infoUsername = document.getElementById('infoUsername');
    const passwordText = document.getElementById('password');
    const infoPassword = document.getElementById('infoPassword');
    const apikeyText = document.getElementById('apikey');
    const infoApiKey = document.getElementById('infoApiKey');
    const cssSelectorChkBox = document.getElementById('cssSelector');

    const saveBtn = document.getElementById('saveBtn');
    const testConnectionBtn = document.getElementById('testConnectionBtn');
    const resetBtn = document.getElementById('resetBtn');
    let isBasicAuth = true;
    let apiKey = null;

    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    const popoverTriggerList = document.querySelectorAll('[data-bs-toggle="popover"]');
    const popoverList = [...popoverTriggerList].map(popoverTriggerEl => new bootstrap.Popover(popoverTriggerEl));

    const bodyClickHandler = () => {
        $('[data-bs-toggle="popover"]').popover('hide');
    };

    const initForm = async () => {
        const data = await chrome.storage.local.get('settings');

        if (data.settings) {
            isBasicAuth = data.settings.isBasicAuth;
            apiKey = data.settings.apikey;
            resetBtn.style.display = '';

            let credentials = isBasicAuth ? atob(data.settings.auth) : apiKey;

            setTextValue(hostText, data.settings.host);
            if (isBasicAuth) {
                setTextValue(usernameText, data.settings.username);
                setTextValue(passwordText, credentials.substr(credentials.indexOf(':') + 1));
                apikeyText.value = null;
            } else {
                usernameText.value = null;
                passwordText.value = null;
                apikeyText.value = processApiKeyView(credentials);
            }

            cssSelectorChkBox.checked = data.settings.saveCssSelector;
        } else {
            resetBtn.style.display = 'none';
        }

        basicAuthRadio.checked = isBasicAuth;
        apiKeyRadio.checked = !isBasicAuth;
        setFieldsVisibility();
        setButtonsState();

        setValidationOptions();

        hostText.focus();
    };

    const formSubmitHandler = event => {
        event.preventDefault();
    };

    $('#settingsForm input').on('input', function() {
        $(this).valid();
    });

    const fieldInputHandler = event => {
        saveBtn.disabled = isRequiredFieldsNotFilled();
        testConnectionBtn.disabled = isRequiredFieldsNotFilled();
    };

    const infoClickHandler = event => {
        let id = event.currentTarget.id;

        event.stopImmediatePropagation();
        event.stopPropagation();

        if (id && id.length) {
            $('#'.concat(id)).tooltip('hide');

            switch (id) {
                case 'infoHost':
                case 'infoSwitcher':
                case 'infoApiKey':
                case 'infoUsername':
                case 'infoPassword':
                    $('[data-bs-toggle="popover"]').popover('hide');
                    $('#' + id + 'Label').popover('show');
                    break;
                default:
                    break;
            }
        }
    };

    const hostKeyDownHandler = event => {
        saveBtn.disabled = isRequiredFieldsNotFilled();
        testConnectionBtn.disabled = isRequiredFieldsNotFilled();

        if (event.keyCode === 13) {
            event.preventDefault();
            if (isBasicAuth) {
                usernameText.focus();
            } else {
                apikeyText.focus();
            }
        }
    };

    const basicAuthRadioClickHandler = event => {
        isBasicAuth = true;
        apiKeyRadio.checked = false;
        setFieldsVisibility();
        setButtonsState();
    };

    const apiKeyRadioClickHandler = event => {
        isBasicAuth = false;
        basicAuthRadio.checked = false;
        setFieldsVisibility();
        setButtonsState();
    };

    const setFieldsVisibility = () => {
        usernameContainer.style.display = isBasicAuth ? '' : 'none';
        passwordContainer.style.display = isBasicAuth ? '' : 'none';
        apikeyLabelContainer.style.display = isBasicAuth ? 'none' : '';
        apikeyContainer.style.display = isBasicAuth ? 'none' : '';
    };

    const setButtonsState = () => {
        saveBtn.disabled = isRequiredFieldsNotFilled();
        testConnectionBtn.disabled = isRequiredFieldsNotFilled();
    };

    const usernameKeyDownHandler = event => {
        setButtonsState();

        if (event.keyCode === 13) {
            event.preventDefault();
            passwordText.focus();
        }
    };

    const passwordKeyDownHandler = event => {
        if (event.keyCode === 13) {
            event.preventDefault();
            cssSelectorChkBox.focus();
        }
    };

    const apikeyKeyDownHandler = event => {
        setButtonsState();
    };

    const processApiKeyView = value => {
        if (value.length === 0 || value.length === 1 || value.length === 2) {
            return value;
        }
        if (value.length > 2) {
            return value[0] + '*'.repeat(40) + value[value.length - 1];
        }
    };

    const cssSelectorKeyDownHandler = () => {
        if (event.keyCode === 13) {
            event.preventDefault();
            if (!isRequiredFieldsNotFilled()) {
                saveBtn.focus();
            } else {
                hostText.focus();
            }
        }
    };

    const hideToasts = () => {
        $('#successToastBody').toast('hide');
        $('#errorToastBody').toast('hide');
    };

    const pasteApiKeyClickHandler = () => {
        apikeyText.removeAttribute(CONSTANTS.ATTRIBUTES.READONLY);
        apikeyText.focus();
        apikeyText.select();
        document.execCommand('paste');
        apiKey = apikeyText.value;
        apikeyText.value = processApiKeyView(apikeyText.value);
        fieldInputHandler();
        apikeyText.setAttribute(CONSTANTS.ATTRIBUTES.READONLY, 'readonly');
        apikeyText.blur();
    };

    const saveClickHandler = async () => {
        hideToasts();
        if ($('#settingsForm').valid()) {
            let savingSettings = {
                host: ApiService.normalizeURL(hostText.value),
                isBasicAuth: isBasicAuth,
                username: isBasicAuth ? usernameText.value : '',
                apikey: !isBasicAuth ? apiKey : '',
                auth: getAuth(),
                saveCssSelector: cssSelectorChkBox.checked
            };

            await chrome.storage.local.set({settings: savingSettings, saveFeatureEnabled: true});
            await loadTemplates(CONSTANTS.NOTIFICATION_MESSAGES.CONFIGURATION_SAVED);
            await initForm();
            chrome.runtime.sendMessage({
                action: CONSTANTS.ACTIONS.ADD_LOG_MENU
            });
        }
    };

    const testConnectionClickHandler = async () => {
        hideToasts();
        $("#overlay").fadeIn(300);

        await ApiService.sendGetRequest(
            ApiService.normalizeURL(hostText.value) + CONSTANTS.REQUEST_PATHS.HEALTH_CHECK,
            getHeaders(),
            (data, status) => {
                ApiService.onSuccessHandler(data, status, CONSTANTS.NOTIFICATION_MESSAGES.CONNECTION_TEST_SUCCESSFUL,
                    isBasicAuth,
                    null,
                    () => {
                        testConnectionBtn.blur();
                    }, true, true);
            },
            errorMessage => {
                ApiService.onErrorHandler(errorMessage,
                    () => {
                        testConnectionBtn.blur();
                    }, true, true);
            }
        );
    };

    const loadTemplates = async additionalMessage => {
        hideToasts();
        $("#overlay").fadeIn(300);

        await ApiService.sendGetRequest(
            ApiService.normalizeURL(hostText.value) + CONSTANTS.REQUEST_PATHS.XPATH_TEMPLATES,
            getHeaders(),
            (data, status) => {
                ApiService.onSuccessHandler(data, status, CONSTANTS.NOTIFICATION_MESSAGES.XPATH_TEMPLATES_RECEIVED, isBasicAuth,
                    additionalMessage,
                    async () => {
                        if (status === 200) {
                            await chrome.storage.local.set({templates: data});
                        }
                    }, true, true);
            },
            errorMessage => {
                ApiService.onErrorHandler(errorMessage, null, true, true);
            }
        );
    };

    const getHeaders = () => {
        return isBasicAuth ?
            {
                'Authorization': 'Basic ' + getAuth(),
            } :
            {
                'X-API-KEY': getAuth(),
            };
    };

    const resetClickHandler = async (event) => {
        hideToasts();
        resetBtn.style.display = 'none';
        hostText.value = null;
        usernameText.value = null;
        passwordText.value = null;
        apikeyText.value = null;
        apiKey = null;
        basicAuthRadio.checked = true;
        basicAuthRadioClickHandler();
        cssSelectorChkBox.checked = false;
        await chrome.storage.local.remove(['settings', 'saveFeatureEnabled', 'templates']);
        chrome.runtime.sendMessage({
            action: CONSTANTS.ACTIONS.REMOVE_LOG_MENU
        });
    };

    const getAuth = () => {
        return isBasicAuth ?
            btoa(usernameText.value + ':' + passwordText.value) :
            apiKey;
    };

    const setValidationOptions = () => {
        const options = {
            rules: {
                host: {
                    required: true,
                    url2: true
                },
                username: {
                    required: true
                },
                password: {
                    required: true
                },
                apikey: {
                    required: true
                }
            },
            messages: {
                host: {
                    required: 'Host is required',
                    url2: 'Please enter a valid URL'
                },
                username: {
                    required: 'Username is required'
                },
                password: {
                    required: 'Password is required'
                },
                apikey: {
                    required: 'API Key is required'
                }
            },
            errorClass: 'is-invalid',
            highlight: function(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element) {
                $(element).removeClass('is-invalid');
            }
        };

        $.validator.addMethod(
            "url2",
            function (value, element) {
                return this.optional(element) || /^(?:(?:(?:https?|ftp):)?\/\/)(?:(?:[^\]\[?\/<~#`!@$^&*()+=}|:";',>{ ]|%[0-9A-Fa-f]{2})+(?::(?:[^\]\[?\/<~#`!@$^&*()+=}|:";',>{ ]|%[0-9A-Fa-f]{2})*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z0-9\u00a1-\uffff][a-z0-9\u00a1-\uffff_-]{0,62})?[a-z0-9\u00a1-\uffff]\.)+(?:[a-z\u00a1-\uffff]{2,}\.?)|(?:(?:[a-z0-9\u00a1-\uffff][a-z0-9\u00a1-\uffff_-]{0,62})?[a-z0-9\u00a1-\uffff])|(?:(?:[a-z0-9\u00a1-\uffff][a-z0-9\u00a1-\uffff_-]{0,62}\.)))(?::\d{2,5})?(?:[/?#]\S*)?$/i.test(value);
            },
            'Please enter a valid URL'
        );

        $('#settingsForm').validate(options);
    };

    const setTextValue = (textElement, value) => {
        if (value) {
            textElement.value = value;
        }
    };

    const isRequiredFieldsNotFilled = () => {
        return isBasicAuth ?
            isEmptyField(hostText.value) || isEmptyField(usernameText.value) :
            isEmptyField(hostText.value) || isEmptyField(apikeyText.value);
    };

    const isEmptyField = value => {
        return value === null || typeof value === 'undefined' || value.length === 0;
    };

    await initForm();

    bodyContainer.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, bodyClickHandler);
    settingsForm.addEventListener(CONSTANTS.EVENTS.DOM.SUBMIT, formSubmitHandler);

    hostText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, hostKeyDownHandler);
    hostText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    hostText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoHost.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);
    infoSwitcher.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);
    basicAuthRadio.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, basicAuthRadioClickHandler);
    apiKeyRadio.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, apiKeyRadioClickHandler);
    usernameText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, usernameKeyDownHandler);
    usernameText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    usernameText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoUsername.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);
    passwordText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, passwordKeyDownHandler);
    infoPassword.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);
    apikeyText.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, apikeyKeyDownHandler);
    apikeyText.addEventListener(CONSTANTS.EVENTS.DOM.INPUT, fieldInputHandler);
    apikeyText.addEventListener(CONSTANTS.EVENTS.DOM.BLUR, fieldInputHandler);
    infoApiKey.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, infoClickHandler);
    cssSelectorChkBox.addEventListener(CONSTANTS.EVENTS.DOM.KEY_DOWN, cssSelectorKeyDownHandler);

    pasteApiKeyBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, pasteApiKeyClickHandler);
    saveBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, saveClickHandler);
    testConnectionBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, testConnectionClickHandler);
    resetBtn.addEventListener(CONSTANTS.EVENTS.DOM.CLICK, resetClickHandler);
});
