const EventsService = {
    events: {},

    subscribe(key, callback) {
        if (!this.events[key]) {
            this.events[key] = [];
        }
        this.events[key].push(callback);
    },

    notify(key, data) {
        if (!this.events[key]) {
            return;
        }
        this.events[key].forEach(callback => callback(data));
    }
};

EventsService.subscribe(CONSTANTS.EVENTS.LOCAL_PLAYER.EVENT_GUTENBERG_CONNECTION_RESPONSE, async data => {
    await setConnectionInfo(data);
});

